/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.sounds.api.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.imb11.sounds.api.config.ConfiguredSound;
import dev.imb11.sounds.api.context.DynamicSoundContext;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import java.util.ArrayList;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_6880;

public class DynamicConfiguredSound<T, F extends DynamicSoundContext<T>>
extends ConfiguredSound {
    public static final Codec<DynamicConfiguredSound> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(ConfiguredSound::getId), (App)class_2960.field_25139.fieldOf("soundEvent").forGetter(sound -> sound.soundEvent.method_40237().method_29177()), (App)Codec.BOOL.fieldOf("shouldPlay").forGetter(ConfiguredSound::shouldPlay), (App)Codec.FLOAT.fieldOf("pitch").forGetter(ConfiguredSound::getPitch), (App)Codec.FLOAT.fieldOf("volume").forGetter(ConfiguredSound::getVolume), (App)Codec.BOOL.fieldOf("enabledDynamic").forGetter(DynamicConfiguredSound::canUseDynamicSounds)).apply((Applicative)instance, DynamicConfiguredSound::new));
    public boolean enableDynamicSounds;

    public DynamicConfiguredSound(String id, class_2960 soundEvent, boolean enabled, float pitch, float volume, boolean enableDynamicSounds) {
        super(id, soundEvent, enabled, pitch, volume);
        this.enableDynamicSounds = enableDynamicSounds;
    }

    public DynamicConfiguredSound(String id, class_3414 soundEvent, boolean enabled, float pitch, float volume, boolean enableDynamicSounds) {
        super(id, soundEvent, enabled, pitch, volume);
        this.enableDynamicSounds = enableDynamicSounds;
    }

    public DynamicConfiguredSound(String id, class_6880.class_6883<class_3414> soundEvent, boolean enabled, float pitch, float volume, boolean enableDynamicSounds) {
        super(id, soundEvent, enabled, pitch, volume);
        this.enableDynamicSounds = enableDynamicSounds;
    }

    public boolean canUseDynamicSounds() {
        return this.enableDynamicSounds;
    }

    public void playDynamicSound(class_3414 event) {
        this.playSound((class_1113)class_1109.method_4757((class_3414)event, (float)this.pitch, (float)this.volume));
    }

    public void playDynamicSound(T context, F contextHandler) {
        class_1113 event = contextHandler.handleContext(context, this.getSoundEvent(), this.pitch, this.volume);
        if (event == null || !this.enableDynamicSounds) {
            this.playSound();
            return;
        }
        this.playSound(event);
    }

    public <E extends ConfiguredSound> ArrayList<Option<?>> addExtraOptions(E defaults) {
        DynamicConfiguredSound dynamicDefaults = (DynamicConfiguredSound)defaults;
        ArrayList<Option<?>> options = super.addExtraOptions(defaults);
        Option shouldDynamic = Option.createBuilder().name((class_2561)class_2561.method_43471((String)"sounds.config.dynamic.name")).description(OptionDescription.createBuilder().text(new class_2561[]{class_2561.method_43471((String)"sounds.config.dynamic.description")}).build()).binding((Object)dynamicDefaults.enableDynamicSounds, () -> this.enableDynamicSounds, val -> {
            this.enableDynamicSounds = val;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).coloured(true).onOffFormatter()).build();
        options.add(shouldDynamic);
        return options;
    }
}

