/*
 * Decompiled with CFR 0.152.
 */
package me.bymartrixx.vtd.gui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.bymartrixx.vtd.data.Category;
import me.bymartrixx.vtd.gui.VTDownloadScreen;
import me.bymartrixx.vtd.gui.widget.CategoryButtonWidget;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_757;

public class CategorySelectionWidget
extends class_362
implements class_4068,
class_6379 {
    private static final boolean SHOW_DEBUG_INFO = false;
    private static final float BACKGROUND_TEXTURE_SIZE = 32.0f;
    private static final int LEFT_RIGHT_PADDING = 2;
    private static final int TOP_BOTTOM_PADDING = 2;
    private static final int LEFT_RIGHT_MARGIN = 4;
    private static final int BUTTON_WIDTH = 120;
    private static final int BUTTON_HEIGHT = 20;
    private static final int BUTTON_MARGIN = 10;
    private static final int SCROLLBAR_HEIGHT = 6;
    private static final int SCROLLBAR_MARGIN = 2;
    private static final int SCROLLBAR_MIN_WIDTH = 32;
    private final List<CategoryButtonWidget> children = new ArrayList<CategoryButtonWidget>();
    private final Map<Category, CategoryButtonWidget> categoryButtons = new HashMap<Category, CategoryButtonWidget>();
    private List<Category> categories;
    private final VTDownloadScreen screen;
    private final int y;
    private int height;
    private int width;
    private int left;
    private int top;
    private int right;
    private int bottom;
    private int startX;
    private int endX;
    private double scrollAmount;
    private boolean scrolling;

    public CategorySelectionWidget(VTDownloadScreen screen, int y) {
        this.screen = screen;
        this.y = y;
        this.calculateDimensions();
    }

    public void init(List<Category> categories, Category selectedCategory) {
        this.setCategories(categories);
        this.initCategoryButtons();
        this.setSelectedCategory(selectedCategory);
    }

    public void updateCategories(List<Category> categories) {
        this.categories = new ArrayList<Category>(categories);
        this.children.clear();
        this.initCategoryButtons();
    }

    public void setCategories(List<Category> categories) {
        this.categories = categories;
    }

    public void initCategoryButtons() {
        for (Category category : this.categories) {
            CategoryButtonWidget button = this.getOrCreateCategoryButton(category);
            this.children.add(button);
        }
        this.calculateDimensions();
    }

    private CategoryButtonWidget getOrCreateCategoryButton(Category category) {
        if (this.categoryButtons.containsKey(category)) {
            return this.categoryButtons.get(category);
        }
        class_5250 text = class_2561.method_43470((String)category.getName());
        CategoryButtonWidget button = new CategoryButtonWidget(this.screen, 120, 20, (class_2561)text, category);
        this.categoryButtons.put(category, button);
        return button;
    }

    public void setSelectedCategory(Category category) {
        this.categoryButtons.forEach((c, button) -> button.setSelected(c == category));
    }

    private int getButtonsWidth() {
        if (this.categories == null) {
            return 0;
        }
        int x = this.categories.size();
        if (x > 0) {
            return x * 120 + (x - 1) * 10;
        }
        return 0;
    }

    private boolean shouldHaveScrollbar() {
        return this.getButtonsWidth() > this.width;
    }

    public void updateScreenWidth() {
        double scroll = this.getScrollAmount() / (double)this.getMaxScroll();
        this.calculateDimensions();
        this.setScrollAmount(Math.round(scroll * (double)this.getMaxScroll()));
    }

    private void calculateDimensions() {
        this.width = this.screen.getLeftWidth() - 8;
        boolean scrollbar = this.shouldHaveScrollbar();
        this.height = 24 + (scrollbar ? 8 : 0);
        this.left = 4;
        this.top = this.y;
        this.right = this.left + this.width;
        this.bottom = this.top + this.height;
        this.startX = 0;
        this.endX = this.right + 4 + (this.screen.field_22789 != this.screen.getLeftWidth() ? 120 : 0);
    }

    private void scroll(int amount) {
        this.setScrollAmount(this.getScrollAmount() + (double)amount);
    }

    private int getMaxScroll() {
        return Math.max(0, this.getButtonsWidth() - this.width + 4);
    }

    private double getScrollAmount() {
        return this.scrollAmount;
    }

    private void setScrollAmount(double scrollAmount) {
        this.scrollAmount = class_3532.method_15350((double)scrollAmount, (double)0.0, (double)this.getMaxScroll());
    }

    private void updateScrollingState(double mouseX, double mouseY, int button) {
        this.scrolling = button == 0 && mouseX >= (double)this.getScrollbarStartX() && mouseX < (double)this.getScrollbarEndX() && mouseY >= (double)this.getScrollbarStartY() && mouseY < (double)this.getScrollbarEndY();
    }

    private void ensureVisible(CategoryButtonWidget button) {
        int buttonLeft = this.getButtonLeft(this.children.indexOf(button));
        int scrollAmount = buttonLeft - this.left - 4 - 120;
        if (scrollAmount < 0) {
            this.scroll(scrollAmount);
        }
        if ((scrollAmount = this.right - buttonLeft - 240) < 0) {
            this.scroll(-scrollAmount);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.updateScrollingState(mouseX, mouseY, button);
        if (!this.method_25405(mouseX, mouseY)) {
            return false;
        }
        return super.method_25402(mouseX, mouseY, button) || this.scrolling;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (button == 0 && this.scrolling) {
            if (mouseX < (double)this.left) {
                this.setScrollAmount(0.0);
            } else if (mouseX > (double)this.right) {
                this.setScrollAmount(this.getMaxScroll());
            } else {
                double maxScroll = Math.max(1, this.getMaxScroll());
                int width = this.getScrollbarEndX() - this.getScrollbarStartX();
                int barSize = this.width * this.width / this.getButtonsWidth();
                barSize = class_3532.method_15340((int)barSize, (int)32, (int)width);
                double factor = Math.max(1.0, maxScroll / (double)(this.width - barSize));
                this.setScrollAmount(this.getScrollAmount() + deltaX * factor);
            }
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        double amount = Math.abs(horizontalAmount) > Math.abs(verticalAmount) ? horizontalAmount : verticalAmount;
        this.setScrollAmount(this.getScrollAmount() - amount * 120.0 / 2.0);
        return true;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX >= (double)this.left && mouseX < (double)this.right && mouseY >= (double)this.top && mouseY < (double)this.bottom;
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground();
        this.renderCategories(graphics, mouseX, mouseY, delta);
        this.renderScrollbar(graphics);
        this.renderMargin();
    }

    private void renderBackground() {
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_437.field_44669);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        bufferBuilder.method_22912((double)this.left, (double)this.bottom, 0.0).method_22913((float)this.left / 32.0f, (float)this.bottom / 32.0f).method_1336(32, 32, 32, 255).method_1344();
        bufferBuilder.method_22912((double)this.right, (double)this.bottom, 0.0).method_22913((float)this.right / 32.0f, (float)this.bottom / 32.0f).method_1336(32, 32, 32, 255).method_1344();
        bufferBuilder.method_22912((double)this.right, (double)this.top, 0.0).method_22913((float)this.right / 32.0f, (float)this.top / 32.0f).method_1336(32, 32, 32, 255).method_1344();
        bufferBuilder.method_22912((double)this.left, (double)this.top, 0.0).method_22913((float)this.left / 32.0f, (float)this.top / 32.0f).method_1336(32, 32, 32, 255).method_1344();
        tessellator.method_1350();
    }

    private void renderCategories(class_332 graphics, int mouseX, int mouseY, float delta) {
        for (int i = 0; i < this.children.size(); ++i) {
            CategoryButtonWidget button = this.children.get(i);
            int left = this.getButtonLeft(i);
            int right = this.getButtonRight(i);
            if (right <= this.left || left >= this.right) continue;
            button.render(graphics, left, this.top + 2, mouseX, mouseY, delta);
        }
    }

    private void renderScrollbar(class_332 graphics) {
        if (this.shouldHaveScrollbar()) {
            int startX = this.getScrollbarStartX();
            int endX = this.getScrollbarEndX();
            int startY = this.getScrollbarStartY();
            int endY = this.getScrollbarEndY();
            int width = endX - startX;
            int size = this.width * this.width / this.getButtonsWidth();
            size = class_3532.method_15340((int)size, (int)32, (int)width);
            int x = (int)this.getScrollAmount() * (width - size) / this.getMaxScroll() + startX;
            if (x < startX) {
                x = startX;
            }
            graphics.method_25294(startX, startY, endX, endY, -16777216);
            graphics.method_25294(x, startY, x + size, endY, -8355712);
            graphics.method_25294(x, startY, x + size - 1, endY - 1, -4144960);
        }
    }

    private void renderMargin() {
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_437.field_44669);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        bufferBuilder.method_22912((double)this.startX, (double)this.bottom, 0.1).method_22913((float)this.startX / 32.0f, (float)this.bottom / 32.0f).method_1336(64, 64, 64, 255).method_1344();
        bufferBuilder.method_22912((double)this.left, (double)this.bottom, 0.1).method_22913((float)this.left / 32.0f, (float)this.bottom / 32.0f).method_1336(64, 64, 64, 255).method_1344();
        bufferBuilder.method_22912((double)this.left, (double)this.top, 0.1).method_22913((float)this.left / 32.0f, (float)this.top / 32.0f).method_1336(64, 64, 64, 255).method_1344();
        bufferBuilder.method_22912((double)this.startX, (double)this.top, 0.1).method_22913((float)this.startX / 32.0f, (float)this.top / 32.0f).method_1336(64, 64, 64, 255).method_1344();
        bufferBuilder.method_22912((double)this.right, (double)this.bottom, 0.1).method_22913((float)this.right / 32.0f, (float)this.bottom / 32.0f).method_1336(64, 64, 64, 255).method_1344();
        bufferBuilder.method_22912((double)this.endX, (double)this.bottom, 0.1).method_22913((float)this.endX / 32.0f, (float)this.bottom / 32.0f).method_1336(64, 64, 64, 255).method_1344();
        bufferBuilder.method_22912((double)this.endX, (double)this.top, 0.1).method_22913((float)this.endX / 32.0f, (float)this.top / 32.0f).method_1336(64, 64, 64, 255).method_1344();
        bufferBuilder.method_22912((double)this.right, (double)this.top, 0.1).method_22913((float)this.right / 32.0f, (float)this.top / 32.0f).method_1336(64, 64, 64, 255).method_1344();
        tessellator.method_1350();
    }

    public void renderDebugInfo(class_332 graphics) {
    }

    private int getButtonLeft(int index) {
        return this.left + 2 - (int)this.getScrollAmount() + index * 130;
    }

    private int getButtonRight(int index) {
        return this.getButtonLeft(index) + 120 + 2;
    }

    private int getScrollbarStartX() {
        return this.left + 2;
    }

    private int getScrollbarEndX() {
        return this.right - 2;
    }

    private int getScrollbarStartY() {
        return this.bottom - 6 - 2;
    }

    private int getScrollbarEndY() {
        return this.bottom - 2;
    }

    public void method_37020(class_6382 builder) {
    }

    public List<? extends class_364> method_25396() {
        return this.children;
    }

    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }
}

