/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.armorstands.client.gui.screen;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import me.roundaround.armorstands.client.gui.screen.AbstractArmorStandScreen;
import me.roundaround.armorstands.client.gui.widget.FlagToggleWidget;
import me.roundaround.armorstands.client.gui.widget.LabelWidget;
import me.roundaround.armorstands.network.ArmorStandFlag;
import me.roundaround.armorstands.network.ScreenType;
import me.roundaround.armorstands.network.UtilityAction;
import me.roundaround.armorstands.network.packet.c2s.UtilityActionPacket;
import me.roundaround.armorstands.screen.ArmorStandScreenHandler;
import net.minecraft.class_2561;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_7919;

public class ArmorStandUtilitiesScreen
extends AbstractArmorStandScreen {
    private static final int BUTTON_WIDTH = 60;
    private static final int BUTTON_HEIGHT = 16;
    private final HashMap<ArmorStandFlag, Boolean> currentValues = new HashMap();
    private final HashMap<ArmorStandFlag, Consumer<Boolean>> listeners = new HashMap();

    public ArmorStandUtilitiesScreen(ArmorStandScreenHandler handler) {
        super(handler, ScreenType.UTILITIES.getDisplayName());
        this.supportsUndoRedo = true;
    }

    @Override
    public ScreenType getScreenType() {
        return ScreenType.UTILITIES;
    }

    @Override
    protected void initStart() {
        super.initStart();
        this.listeners.clear();
        this.refreshFlags();
    }

    @Override
    protected void initLeft() {
        super.initLeft();
        this.addLabel(LabelWidget.builder((class_2561)class_2561.method_43471((String)"armorstands.utility.setup"), 4, this.field_22790 - 4 - 48 - 6).alignedBottom().justifiedLeft().shiftForPadding().build());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"armorstands.utility.prepare"), button -> UtilityActionPacket.sendToServer(UtilityAction.PREPARE)).method_46437(60, 16).method_46433(4, this.field_22790 - 4 - 48 - 4).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorstands.utility.prepare.tooltip"))).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"armorstands.utility.toolRack"), button -> UtilityActionPacket.sendToServer(UtilityAction.TOOL_RACK)).method_46437(60, 16).method_46433(66, this.field_22790 - 4 - 48 - 4).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorstands.utility.toolRack.tooltip"))).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"armorstands.utility.uprightItem"), button -> UtilityActionPacket.sendToServer(UtilityAction.UPRIGHT_ITEM.forSmall(ArmorStandFlag.SMALL.getValue(this.armorStand)))).method_46437(60, 16).method_46433(4, this.field_22790 - 4 - 32 - 2).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorstands.utility.uprightItem.tooltip"))).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"armorstands.utility.flatItem"), button -> UtilityActionPacket.sendToServer(UtilityAction.FLAT_ITEM.forSmall(ArmorStandFlag.SMALL.getValue(this.armorStand)))).method_46437(60, 16).method_46433(66, this.field_22790 - 4 - 32 - 2).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorstands.utility.flatItem.tooltip"))).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"armorstands.utility.block"), button -> UtilityActionPacket.sendToServer(UtilityAction.BLOCK.forSmall(ArmorStandFlag.SMALL.getValue(this.armorStand)))).method_46437(60, 16).method_46433(4, this.field_22790 - 4 - 16).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorstands.utility.block.tooltip"))).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"armorstands.utility.tool"), button -> UtilityActionPacket.sendToServer(UtilityAction.TOOL.forSmall(ArmorStandFlag.SMALL.getValue(this.armorStand)))).method_46437(60, 16).method_46433(66, this.field_22790 - 4 - 16).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"armorstands.utility.tool.tooltip"))).method_46431());
    }

    @Override
    protected void initRight() {
        super.initRight();
        List<ArmorStandFlag> flags = ArmorStandFlag.getFlags();
        for (int i = flags.size() - 1; i >= 0; --i) {
            this.addFlagToggleWidget(flags.get(flags.size() - i - 1), i);
        }
    }

    @Override
    public void method_37432() {
        super.method_37432();
        this.refreshFlags();
    }

    private void refreshFlags() {
        Arrays.stream(ArmorStandFlag.values()).forEach(flag -> {
            boolean curr;
            Consumer<Boolean> listener = this.listeners.getOrDefault(flag, value -> {});
            boolean prev = this.currentValues.getOrDefault(flag, !(curr = flag.getValue(this.armorStand)));
            if (curr != prev) {
                this.currentValues.put((ArmorStandFlag)((Object)flag), curr);
                listener.accept(curr);
            }
        });
    }

    private void addFlagToggleWidget(ArmorStandFlag flag, int index) {
        int xPos = this.field_22789 - 4;
        int yPos = this.field_22790 - (index + 1) * 16;
        FlagToggleWidget widget = new FlagToggleWidget(this.field_22793, flag, this.currentValues.get((Object)flag), xPos, yPos);
        this.method_37063((class_364)widget);
        this.listeners.put(flag, widget::setValue);
    }
}

