/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.impl.common;

import info.u_team.u_team_core.api.network.NetworkContext;
import info.u_team.u_team_core.api.network.NetworkEnvironment;
import info.u_team.u_team_core.api.network.NetworkHandler;
import info.u_team.u_team_core.api.network.NetworkMessage;
import info.u_team.u_team_core.api.network.NetworkPayload;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonNetworkHandler
implements NetworkHandler {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)"NetworkHandler");
    protected final class_2960 channel;
    protected final int protocolVersion;
    protected final Set<MessageNetworkPayload<?>> messages;

    protected CommonNetworkHandler(class_2960 channel, int protocolVersion) {
        this.channel = channel;
        this.protocolVersion = protocolVersion;
        this.messages = new HashSet();
    }

    protected abstract <M> NetworkMessage<M> createMessage(MessageNetworkPayload<M> var1);

    protected <M> MessageNetworkPayload<M> createMessageNetworkPayload(class_2960 messageId, NetworkPayload<M> payload) {
        return new MessageNetworkPayload<M>(messageId, payload);
    }

    @Override
    public <M> NetworkMessage<M> register(String id, NetworkPayload<M> payload) {
        class_2960 messageId = this.channel.method_48331("/" + id);
        if (payload.getHandlerEnvironment().isEmpty()) {
            throw new IllegalArgumentException("Handler environment cannot be empty for message id " + messageId);
        }
        MessageNetworkPayload<M> messagePayload = this.createMessageNetworkPayload(messageId, payload);
        if (!this.messages.add(messagePayload)) {
            throw new IllegalArgumentException("Duplicate message id " + messageId);
        }
        return this.createMessage(messagePayload);
    }

    @Override
    public class_2960 getChannel() {
        return this.channel;
    }

    @Override
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    protected static class MessageNetworkPayload<M> {
        private final class_2960 messageId;
        private final NetworkPayload<M> payload;

        protected MessageNetworkPayload(class_2960 messageId, NetworkPayload<M> payload) {
            this.messageId = messageId;
            this.payload = payload;
        }

        public class_2960 getMessageId() {
            return this.messageId;
        }

        public NetworkPayload<M> getPayload() {
            return this.payload;
        }

        public boolean canWrite(NetworkEnvironment handlerEnvironment) {
            if (!this.payload.getHandlerEnvironment().contains((Object)handlerEnvironment)) {
                LOGGER.error("Failed to write message to channel {} because not handler is defined on the {} environment. Expected {} environment", new Object[]{this.messageId, handlerEnvironment, this.payload.getHandlerEnvironment()});
                return false;
            }
            return true;
        }

        public void write(M message, class_2540 buffer) {
            try {
                this.payload.write(message, buffer);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to write message {} to channel {}", new Object[]{message.getClass(), this.messageId, ex});
            }
        }

        public M read(class_2540 buffer) {
            try {
                return this.payload.read(buffer);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to read message in channel {}", (Object)this.messageId, (Object)ex);
                return null;
            }
        }

        public void handle(M message, NetworkContext context) {
            if (message == null) {
                return;
            }
            NetworkEnvironment current = context.getEnvironment();
            if (!this.payload.getHandlerEnvironment().contains((Object)current)) {
                LOGGER.error("Message {} in channel {} cannot be handled on the {} environment. Expected {} environment", new Object[]{message.getClass(), this.messageId, current, this.payload.getHandlerEnvironment()});
                return;
            }
            try {
                this.payload.handle(message, context);
            }
            catch (Exception ex) {
                LOGGER.error("Failed to handle message {} in channel {}", new Object[]{message.getClass(), this.messageId, ex});
            }
        }

        public int hashCode() {
            return Objects.hash(this.messageId);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            MessageNetworkPayload other = (MessageNetworkPayload)object;
            return Objects.equals(this.messageId, other.messageId);
        }
    }

    protected static abstract class CommonNetworkContext
    implements NetworkContext {
        protected final class_2960 messageId;

        public CommonNetworkContext(class_2960 messageId) {
            this.messageId = messageId;
        }

        protected abstract CompletableFuture<Void> execute(Runnable var1);

        @Override
        public final CompletableFuture<Void> executeOnMainThread(Runnable runnable) {
            return this.execute(runnable).exceptionally(ex -> {
                LOGGER.error("Failed to handle synchronized message in channel {}", (Object)this.messageId, ex);
                return null;
            });
        }
    }

    protected static abstract class CommonNetworkMessage<M>
    implements NetworkMessage<M> {
        protected final MessageNetworkPayload<M> messagePayload;

        protected CommonNetworkMessage(MessageNetworkPayload<M> messagePayload) {
            this.messagePayload = messagePayload;
        }

        protected abstract void sendPacketToPlayer(class_3222 var1, M var2);

        protected abstract void sendPacketToConnection(class_2535 var1, M var2);

        protected abstract void sendPacketToServer(M var1);

        @Override
        public final void sendToPlayer(class_3222 player, M message) {
            if (this.messagePayload.canWrite(NetworkEnvironment.CLIENT)) {
                this.sendPacketToPlayer(player, message);
            }
        }

        @Override
        public final void sendToConnection(class_2535 connection, M message) {
            if (this.messagePayload.canWrite(NetworkEnvironment.CLIENT)) {
                this.sendPacketToConnection(connection, message);
            }
        }

        @Override
        public final void sendToServer(M message) {
            if (this.messagePayload.canWrite(NetworkEnvironment.SERVER)) {
                this.sendPacketToServer(message);
            }
        }
    }
}

