/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.menu;

import info.u_team.u_team_core.api.Platform;
import info.u_team.u_team_core.api.block.MenuSyncedBlockEntity;
import info.u_team.u_team_core.api.network.NetworkEnvironment;
import info.u_team.u_team_core.menu.UContainerMenu;
import info.u_team.u_team_core.util.CastUtil;
import info.u_team.u_team_core.util.EnvironmentUtil;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1661;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3917;

public abstract class UBlockEntityContainerMenu<T extends class_2586>
extends UContainerMenu {
    protected final class_1661 playerInventory;
    protected final T blockEntity;

    public UBlockEntityContainerMenu(class_3917<?> menuType, int containerId, class_1661 playerInventory, T blockEntity) {
        this(menuType, containerId, playerInventory, blockEntity, true);
    }

    public UBlockEntityContainerMenu(class_3917<?> menuType, int containerId, class_1661 playerInventory, T blockEntity, boolean callInit) {
        super(menuType, containerId);
        this.playerInventory = playerInventory;
        this.blockEntity = blockEntity;
        if (callInit) {
            this.init(NetworkEnvironment.SERVER);
        }
    }

    public UBlockEntityContainerMenu(class_3917<?> menuType, int containerId, class_1661 playerInventory, class_2540 buffer) {
        this(menuType, containerId, playerInventory, buffer, true);
    }

    public UBlockEntityContainerMenu(class_3917<?> menuType, int containerId, class_1661 playerInventory, class_2540 buffer, boolean callInit) {
        super(menuType, containerId);
        this.playerInventory = playerInventory;
        T t = this.blockEntity = (class_2586)EnvironmentUtil.callWhen(Platform.Environment.CLIENT, () -> () -> Client.getClientBlockEntity(buffer));
        if (t instanceof MenuSyncedBlockEntity) {
            MenuSyncedBlockEntity syncedBlockEntity = (MenuSyncedBlockEntity)t;
            class_2540 data = new class_2540(Unpooled.wrappedBuffer((byte[])buffer.method_10803(32592)));
            syncedBlockEntity.handleInitialMenuDataFromServer(data);
            data.release();
        }
        if (callInit) {
            this.init(NetworkEnvironment.CLIENT);
        }
    }

    protected abstract void init(NetworkEnvironment var1);

    public T getBlockEntity() {
        return this.blockEntity;
    }

    private static class Client {
        private Client() {
        }

        private static <T extends class_2586> T getClientBlockEntity(class_2540 buffer) {
            class_2338 pos = buffer.method_10811();
            class_2586 blockEntity = class_310.method_1551().field_1687.method_8321(pos);
            if (blockEntity == null) {
                throw new IllegalStateException("The client block entity at (" + pos.method_23854() + ") does not exist.");
            }
            return (T)((class_2586)CastUtil.uncheckedCast(blockEntity));
        }
    }
}

