/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import info.u_team.u_team_core.util.RGBA;

public class RGB {
    public static final RGB BLACK = new RGB(0);
    public static final RGB WHITE = new RGB(0xFFFFFF);
    private final int red;
    private final int green;
    private final int blue;
    private final int colorRGB;

    public RGB(int color) {
        this.red = color >> 16 & 0xFF;
        this.green = color >> 8 & 0xFF;
        this.blue = color & 0xFF;
        this.colorRGB = color;
    }

    public RGB(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.colorRGB = (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF;
    }

    public RGB(float red, float green, float blue) {
        this.red = (int)(red * 255.0f);
        this.green = (int)(green * 255.0f);
        this.blue = (int)(blue * 255.0f);
        this.colorRGB = (this.red & 0xFF) << 16 | (this.green & 0xFF) << 8 | this.blue & 0xFF;
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public float getRedComponent() {
        return (float)this.red / 255.0f;
    }

    public float getGreenComponent() {
        return (float)this.green / 255.0f;
    }

    public float getBlueComponent() {
        return (float)this.blue / 255.0f;
    }

    public int getColor() {
        return this.colorRGB;
    }

    public RGB setRed(int red) {
        return new RGB(red, this.getGreen(), this.getBlue());
    }

    public RGB setGreen(int green) {
        return new RGB(this.getRed(), green, this.getBlue());
    }

    public RGB setBlue(int blue) {
        return new RGB(this.getRed(), this.getGreen(), blue);
    }

    public RGB setRedComponent(float red) {
        return new RGB((int)(red * 255.0f), this.getGreen(), this.getBlue());
    }

    public RGB setGreenComponent(float green) {
        return new RGB(this.getRed(), (int)(green * 255.0f), this.getBlue());
    }

    public RGB setBlueComponent(float blue) {
        return new RGB(this.getRed(), this.getGreen(), (int)(blue * 255.0f));
    }

    public String toString() {
        return "RGB [red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + "]";
    }

    public static RGB fromRGBA(RGBA rgba) {
        return new RGB(rgba.getRed(), rgba.getGreen(), rgba.getBlue());
    }
}

