/*
 * Decompiled with CFR 0.152.
 */
package eu.gflash.notifmod.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import eu.gflash.notifmod.client.gui.BaseScreen;
import eu.gflash.notifmod.client.gui.widgets.CustomButtonWidget;
import eu.gflash.notifmod.util.NumUtil;
import eu.gflash.notifmod.util.ReminderTimer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_757;

public class ReminderListScreen
extends BaseScreen {
    private static final class_2960 BACKGROUND = new class_2960("notifmod:textures/gui_reminder_list.png");
    private static final class_2960 MASK = new class_2960("notifmod:textures/gui_reminder_list_mask.png");
    private static final class_2561 TEXT_TITLE = class_2561.method_43471((String)"gui.screen.reminderList.title");
    private static final class_2561 TEXT_ENTRY_UNTITLED = class_2561.method_43471((String)"gui.screen.reminderList.entry.untitled");
    private static final class_2561 TEXT_ENTRY_STOP = class_2561.method_43471((String)"gui.screen.reminderList.entry.stop");
    private static final int PANEL_WIDTH = 250;
    private static final int PANEL_HEIGHT = 146;

    protected ReminderListScreen() {
        super(TEXT_TITLE, 250, 146, BACKGROUND);
    }

    @Override
    public void renderForeground(class_332 context, int mouseX, int mouseY, float delta) {
        super.renderForeground(context, mouseX, mouseY, delta);
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        context.method_25302(MASK, this.panelX, this.panelY, 0, 0, this.panelWidth, this.panelHeight);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.method_37063((class_364)new ReminderListWidget());
    }

    public static void open() {
        class_310.method_1551().method_1507((class_437)new ReminderListScreen());
    }

    public class ReminderListWidget
    extends class_4265<ReminderEntry> {
        private static final int ITEM_HEIGHT = 20;
        private static final int WIDGET_WIDTH = 240;
        private static final int WIDGET_HEIGHT = 106;
        private static final int RELATIVE_BOTTOM = 126;
        private final int buttonX;
        private final int timeX;
        private final int maxTitleWidth;
        private final int trimTitleWidth;

        public ReminderListWidget() {
            super(ReminderListScreen.this.field_22787, 240, 106, ReminderListScreen.this.panelY + 20, ReminderListScreen.this.panelY + 126, 20);
            this.field_19088 = ReminderListScreen.this.wX();
            this.field_19087 += this.field_19088;
            this.method_31322(false);
            ReminderTimer.getActive().stream().sorted(Comparator.comparingInt(ReminderTimer::getRemaining).reversed()).forEach(timer -> this.method_25321((class_350.class_351)new ReminderEntry((ReminderTimer)timer)));
            this.buttonX = this.field_19087 - (this.method_25331() > 0 ? 62 : 52);
            this.timeX = this.buttonX - ReminderListScreen.this.field_22793.method_1727("00:00:00") - 6;
            this.maxTitleWidth = this.timeX - this.field_19088 - 6;
            this.trimTitleWidth = this.maxTitleWidth - ReminderListScreen.this.field_22793.method_1727("...");
            this.method_25396().forEach(ReminderEntry::init);
        }

        protected int method_25329() {
            return this.field_19087 - 6;
        }

        public int method_25322() {
            return this.field_22742;
        }

        public class ReminderEntry
        extends class_4265.class_4266<ReminderEntry> {
            private final ReminderTimer timer;
            private final CustomButtonWidget stopButton;
            private class_2561 title = TEXT_ENTRY_UNTITLED;

            public ReminderEntry(ReminderTimer timer) {
                this.timer = timer;
                this.stopButton = new CustomButtonWidget(0, 0, 50, 20, TEXT_ENTRY_STOP, b -> this.timer.kill()){

                    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
                        super.method_25394(context, ReminderListWidget.this.method_25405(mouseX, mouseY) ? mouseX : -1, mouseY, delta);
                    }
                };
            }

            public void init() {
                this.stopButton.method_46421(ReminderListWidget.this.buttonX);
                if (this.timer.hasName()) {
                    this.title = class_2561.method_30163((String)this.trimTitle(this.timer.getName()));
                }
            }

            private String trimTitle(String title) {
                if (ReminderListScreen.this.field_22793.method_1727(title) > ReminderListWidget.this.maxTitleWidth) {
                    return ReminderListScreen.this.field_22793.method_27523(title, ReminderListWidget.this.trimTitleWidth) + "...";
                }
                return title;
            }

            public List<? extends class_6379> method_37025() {
                return Collections.singletonList(this.stopButton);
            }

            public List<? extends class_364> method_25396() {
                return Collections.singletonList(this.stopButton);
            }

            public boolean method_25405(double mouseX, double mouseY) {
                return ReminderListWidget.this.method_25405(mouseX, mouseY) && super.method_25405(mouseX, mouseY);
            }

            public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                if (this.method_25405(mouseX, mouseY)) {
                    class_289 tessellator = class_289.method_1348();
                    class_287 bufferBuilder = tessellator.method_1349();
                    RenderSystem.enableBlend();
                    RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ZERO, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
                    RenderSystem.setShader(class_757::method_34540);
                    bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
                    int minX = x - 2;
                    int maxX = minX + entryWidth;
                    int maxY = y + 20;
                    Arrays.stream(new int[][]{{minX, maxY}, {maxX, maxY}, {maxX, y}, {minX, y}}).forEach(c -> bufferBuilder.method_22912((double)c[0], (double)c[1], 0.0).method_1336(64, 64, 64, 120).method_1344());
                    tessellator.method_1350();
                    RenderSystem.disableBlend();
                }
                int textY = y + (entryHeight >> 1) - 2;
                ReminderListScreen.this.drawTextWithShadow(context, this.title, x, textY, 0xFFFFFF);
                this.stopButton.field_22763 = this.timer.isActive();
                if (this.stopButton.field_22763) {
                    ReminderListScreen.this.drawTextWithShadow(context, NumUtil.secToHMSString(this.timer.getRemaining()), ReminderListWidget.this.timeX, textY, this.timer.isRepeating() ? 0xFFC4FF : 0xC4FFFF);
                } else {
                    ReminderListScreen.this.drawTextWithShadow(context, "--:--:--", ReminderListWidget.this.timeX, textY, 0xFFFFC4);
                }
                this.stopButton.method_46419(y);
                this.stopButton.method_25394(context, mouseX, mouseY, tickDelta);
            }
        }
    }
}

