/*
 * Decompiled with CFR 0.152.
 */
package eu.gflash.notifmod.client.listeners;

import eu.gflash.notifmod.config.ModConfig;
import eu.gflash.notifmod.util.Message;
import eu.gflash.notifmod.util.TextUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class DamageListener {
    private static final Map<ItemStackWrapper, TrackedInfo> itemTracker = new HashMap<ItemStackWrapper, TrackedInfo>();

    public static void onDamage(class_1799 itemStack) {
        ModConfig.Durability settings = ModConfig.getInstance().durability;
        if (itemStack.method_7919() == itemStack.method_7936() - 1 && settings.unbreakableItems.contains(itemStack)) {
            settings.damageSettings.stop.notif(() -> TextUtil.buildText(new class_2561[]{Message.CHAT_PRE_WARN, class_2561.method_43469((String)"msg.notifmod.durability.damage.brokenUnbreakable.long", (Object[])new Object[]{TextUtil.getWithFormat(itemStack.method_7964(), class_124.field_1075)})}), () -> class_2561.method_43469((String)"msg.notifmod.durability.damage.brokenUnbreakable.short", (Object[])new Object[]{TextUtil.getWithFormat(itemStack.method_7964(), class_124.field_1075)}));
        }
        int durabilityPercentage = DamageListener.getDurabilityPercentage(itemStack);
        TrackedInfo itemInfo = itemTracker.get(new ItemStackWrapper(itemStack));
        if (itemInfo == null) {
            itemInfo = new TrackedInfo(itemStack);
            itemTracker.put(new ItemStackWrapper(itemStack), itemInfo);
        } else if (!itemInfo.setLastPercentNotif(durabilityPercentage)) {
            return;
        }
        if (durabilityPercentage <= settings.repairSettings.unlockThreshold) {
            itemInfo.setUnlockedRepairNotif(true);
        }
        if (durabilityPercentage > 0 && DamageListener.isPastDmgThreshold(itemStack.method_7936(), durabilityPercentage)) {
            settings.damageSettings.damage.notif(() -> TextUtil.buildText(new class_2561[]{Message.CHAT_PRE_WARN, class_2561.method_43469((String)"msg.notifmod.durability.damage.percentage.long", (Object[])new Object[]{TextUtil.getWithFormat(itemStack.method_7964(), class_124.field_1075), TextUtil.getWithFormat(durabilityPercentage, class_124.field_1061)})}), () -> class_2561.method_43469((String)"msg.notifmod.durability.damage.percentage.short", (Object[])new Object[]{TextUtil.getWithFormat(itemStack.method_7964(), class_124.field_1075), TextUtil.getWithFormat(durabilityPercentage, class_124.field_1061)}));
        }
    }

    public static void onRepair(class_1799 itemStack) {
        TrackedInfo itemInfo;
        ModConfig.Durability settings = ModConfig.getInstance().durability;
        if (!itemStack.method_7986() && (itemInfo = itemTracker.get(new ItemStackWrapper(itemStack))) != null && itemInfo.setUnlockedRepairNotif(false)) {
            settings.repairSettings.notif(() -> TextUtil.buildText(new class_2561[]{Message.CHAT_PRE_INFO, class_2561.method_43469((String)"msg.notifmod.durability.repair.long", (Object[])new Object[]{TextUtil.getWithFormat(itemStack.method_7964(), class_124.field_1075), TextUtil.getWithFormat((class_2561)class_2561.method_43471((String)"msg.notifmod.durability.repair.long.full"), class_124.field_1060)})}), () -> class_2561.method_43469((String)"msg.notifmod.durability.repair.short", (Object[])new Object[]{TextUtil.getWithFormat(itemStack.method_7964(), class_124.field_1075), TextUtil.getWithFormat((class_2561)class_2561.method_43471((String)"msg.notifmod.durability.repair.short.full"), class_124.field_1060)}));
        }
    }

    public static boolean isTracked(class_1799 itemStack) {
        ModConfig.Durability settings = ModConfig.getInstance().durability;
        if (!settings.enabled) {
            return false;
        }
        if (settings.trackedItems.contains(itemStack)) {
            return true;
        }
        if (settings.alwaysNamed && itemStack.method_7938()) {
            return true;
        }
        return settings.alwaysEnchanted && itemStack.method_7942() && !settings.blacklistedEnchantedItems.contains(itemStack);
    }

    private static boolean isPastDmgThreshold(int maxDamage, int durabilityPercentage) {
        ModConfig.Durability.Damage settings = ModConfig.getInstance().durability.damageSettings;
        if (maxDamage > settings.weakThreshold) {
            return durabilityPercentage <= settings.damageThreshold;
        }
        return durabilityPercentage <= settings.weakDamageThreshold;
    }

    private static int getDurabilityPercentage(class_1799 itemStack) {
        return 100 - Math.round(100.0f * (float)itemStack.method_7919() / (float)itemStack.method_7936());
    }

    private record ItemStackWrapper(class_1799 itemStack) {
        public class_1799 getNoDmg() {
            class_1799 itemStack = this.itemStack.method_7972();
            itemStack.method_7974(0);
            return itemStack;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return class_1799.method_7973((class_1799)this.getNoDmg(), (class_1799)((ItemStackWrapper)o).getNoDmg());
        }

        @Override
        public int hashCode() {
            class_1799 noDmg = this.getNoDmg();
            return new HashCodeBuilder(19, 61).append(noDmg.method_7947()).append((Object)noDmg.method_7909().toString()).append((Object)noDmg.method_7969()).toHashCode();
        }
    }

    private static class TrackedInfo {
        private boolean unlockedRepairNotif;
        private int lastPercentNotif;

        public TrackedInfo(class_1799 itemStack) {
            this.lastPercentNotif = DamageListener.getDurabilityPercentage(itemStack);
            this.unlockedRepairNotif = this.lastPercentNotif < ModConfig.getInstance().durability.repairSettings.unlockThreshold;
        }

        public boolean isUnlockedRepairNotif() {
            return this.unlockedRepairNotif;
        }

        public boolean setUnlockedRepairNotif(boolean unlockedRepairNotif) {
            boolean temp = this.unlockedRepairNotif;
            this.unlockedRepairNotif = unlockedRepairNotif;
            return temp;
        }

        public int getLastPercentNotif() {
            return this.lastPercentNotif;
        }

        public boolean setLastPercentNotif(int lastPercentNotif) {
            if (this.lastPercentNotif != lastPercentNotif) {
                this.lastPercentNotif = lastPercentNotif;
                return true;
            }
            return false;
        }
    }
}

