/*
 * Decompiled with CFR 0.152.
 */
package eu.gflash.notifmod.client.listeners;

import eu.gflash.notifmod.config.ModConfig;
import eu.gflash.notifmod.util.Log;
import eu.gflash.notifmod.util.Message;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class MessageListener {
    public static Message.Incoming onMessagePreprocess(Message.Incoming msg) {
        class_746 player = class_310.method_1551().field_1724;
        if (!(player == null || msg.hasSender() && msg.senderIs((class_1657)player) || msg.isEmpty())) {
            MessageListener.onIncomingMessagePreprocess(msg.channel(), msg.toString(), msg);
        } else {
            msg.notifType = Message.Incoming.NotifType.DROPPED;
        }
        return msg;
    }

    private static void onIncomingMessagePreprocess(Message.Channel channel, String message, Message.Incoming msg) {
        ModConfig.Chat settings = ModConfig.getInstance().chat;
        if (MessageListener.procNotifType(settings.mention, channel, message, msg, Message.Incoming.NotifType.MENTION)) {
            return;
        }
        MessageListener.procNotifType(settings.message, channel, message, msg, Message.Incoming.NotifType.MESSAGE);
    }

    private static boolean procNotifType(ModConfig.Chat.Sub settings, Message.Channel channel, String message, Message.Incoming msg, Message.Incoming.NotifType type) {
        if (!settings.enabled || !settings.relevantPatternMatches(channel, message)) {
            return false;
        }
        msg.notifType = type;
        return true;
    }

    public static void onMessage(Message.Incoming msg) {
        if (msg.notifType == Message.Incoming.NotifType.DROPPED) {
            return;
        }
        ModConfig.Chat settings = ModConfig.getInstance().chat;
        Message.Channel channel = msg.channel();
        String message = msg.toString();
        boolean logInfo = settings.LogMsgInfo;
        switch (msg.notifType) {
            case MENTION: {
                MessageListener.notify(settings.mention, channel, message, "mention", logInfo);
                break;
            }
            case MESSAGE: {
                MessageListener.notify(settings.message, channel, message, "message", logInfo);
                break;
            }
            case NONE: {
                if (!logInfo) break;
                Log.info("Incoming non-matching message (" + channel + ", " + (settings.message.isCaseSens(channel) ? "case-sens" : "case-insens") + " messages, " + (settings.mention.isCaseSens(channel) ? "case-sens" : "case-insens") + " mentions): " + message);
            }
        }
    }

    private static void notify(ModConfig.Chat.Sub settings, Message.Channel channel, String message, String type, boolean logInfo) {
        settings.playSound();
        if (logInfo) {
            Log.info("Incoming matching message (" + channel + ", " + type + ", " + (settings.isCaseSens(channel) ? "case-sensitive" : "case-insensitive") + "): " + message);
        }
    }
}

