/*
 * Decompiled with CFR 0.152.
 */
package eu.gflash.notifmod.config.types;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import eu.gflash.notifmod.config.ConfigTypeBase;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import me.shedaniel.autoconfig.gui.registry.api.GuiRegistryAccess;
import me.shedaniel.autoconfig.util.Utils;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;

@JsonAdapter(value=Adapter.class)
public class RegExPattern
extends ConfigTypeBase {
    private final String original;
    private Pattern pattern;
    private String lastName;
    private boolean caseSensitive = false;

    public RegExPattern(String pattern) {
        this.original = pattern;
        this.compile();
    }

    public RegExPattern setCaseSensitivity(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        return this;
    }

    public void compile() {
        String currName;
        class_746 player = class_310.method_1551().field_1724;
        String string = currName = player == null ? null : player.method_5476().getString();
        if (Objects.equals(this.lastName, currName) && this.pattern != null && this.pattern.flags() == 0 == this.caseSensitive) {
            return;
        }
        this.lastName = currName;
        String preppedPattern = this.original.replace("\\p", currName == null ? "." : currName);
        try {
            this.pattern = Pattern.compile(preppedPattern, this.caseSensitive ? 0 : 66);
        }
        catch (PatternSyntaxException ex) {
            this.pattern = Pattern.compile(".*");
            this.error = ex.getDescription();
        }
    }

    public static RegExPattern getDefault() {
        return new RegExPattern(".*");
    }

    @Override
    protected class_2561 getUnsafeError() {
        return class_2561.method_43469((String)"error.config.notifmod.RegExPattern", (Object[])new Object[]{this.error});
    }

    public static Optional<class_2561> validate(String pattern) {
        return new RegExPattern(pattern).getError();
    }

    public boolean matches(String str) {
        return this.get().matcher(str).matches();
    }

    public Pattern get() {
        this.compile();
        return this.pattern;
    }

    public boolean isEmpty() {
        return this.original.isEmpty();
    }

    public String toString() {
        return this.original;
    }

    public static class Provider
    extends ConfigTypeBase.ProviderBase<String> {
        @Override
        public AbstractConfigListEntry<String> getEntry(String i13n, Field field, Object config, Object defaults, GuiRegistryAccess registry) {
            return ENTRY_BUILDER.startStrField((class_2561)class_2561.method_43471((String)i13n), ((RegExPattern)Utils.getUnsafely((Field)field, (Object)config, (Object)RegExPattern.getDefault())).toString()).setDefaultValue(() -> Utils.getUnsafely((Field)field, (Object)defaults).toString()).setSaveConsumer(newValue -> Utils.setUnsafely((Field)field, (Object)config, (Object)new RegExPattern((String)newValue))).setErrorSupplier(RegExPattern::validate).build();
        }
    }

    public static class Adapter
    extends TypeAdapter<RegExPattern> {
        public void write(JsonWriter out, RegExPattern value) throws IOException {
            out.value(value.toString());
        }

        public RegExPattern read(JsonReader in) throws IOException {
            return new RegExPattern(in.nextString());
        }
    }
}

