/*
 * Decompiled with CFR 0.152.
 */
package eu.gflash.notifmod.mixin;

import eu.gflash.notifmod.client.listeners.DamageListener;
import eu.gflash.notifmod.client.listeners.PlayerListListener;
import eu.gflash.notifmod.client.listeners.WorldLoadListener;
import eu.gflash.notifmod.client.listeners.WorldTimeListener;
import eu.gflash.notifmod.util.ItemUtil;
import eu.gflash.notifmod.util.ReminderTimer;
import eu.gflash.notifmod.util.ThreadUtils;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2653;
import net.minecraft.class_2703;
import net.minecraft.class_2761;
import net.minecraft.class_2779;
import net.minecraft.class_310;
import net.minecraft.class_434;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.class_7828;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_634.class})
public class ClientPlayNetworkHandlerMixin {
    @Unique
    private static final int TICKS_PER_DAY = 24000;
    @Unique
    private static boolean loaded = false;
    @Shadow
    @Final
    private Map<UUID, class_640> field_3693;
    @Shadow
    @Final
    private Set<class_640> field_40489;

    @Unique
    private class_310 getClient() {
        return class_310.method_1551();
    }

    @Inject(method={"handlePlayerListAction(Lnet/minecraft/network/packet/s2c/play/PlayerListS2CPacket$Action;Lnet/minecraft/network/packet/s2c/play/PlayerListS2CPacket$Entry;Lnet/minecraft/client/network/PlayerListEntry;)V"}, at={@At(value="HEAD")})
    public void onPlayerListAction(class_2703.class_5893 action, class_2703.class_2705 receivedEntry, class_640 currentEntry, CallbackInfo ci) {
        if (!loaded || action != class_2703.class_5893.field_29136) {
            return;
        }
        if (receivedEntry.comp_1108()) {
            PlayerListListener.onJoin(currentEntry);
        }
    }

    @Inject(method={"onPlayerRemove(Lnet/minecraft/network/packet/s2c/play/PlayerRemoveS2CPacket;)V"}, at={@At(value="HEAD")})
    public void onPlayerRemove(class_7828 packet, CallbackInfo ci) {
        if (ThreadUtils.isMainThread()) {
            packet.comp_1105().stream().filter(this.field_3693::containsKey).map(this.field_3693::get).filter(this.field_40489::contains).findFirst().ifPresent(PlayerListListener::onLeave);
        }
    }

    @Inject(method={"onAdvancements(Lnet/minecraft/network/packet/s2c/play/AdvancementUpdateS2CPacket;)V"}, at={@At(value="RETURN")})
    public void onAdvancements(class_2779 packet, CallbackInfo ci) {
        if (!loaded) {
            loaded = true;
            WorldLoadListener.onLoad();
        }
    }

    @Inject(method={"clearWorld()V"}, at={@At(value="RETURN")})
    public void clearWorld(CallbackInfo ci) {
        loaded = false;
        WorldLoadListener.reset();
        WorldTimeListener.reset();
        ReminderTimer.killAll();
    }

    @Inject(method={"onScreenHandlerSlotUpdate(Lnet/minecraft/network/packet/s2c/play/ScreenHandlerSlotUpdateS2CPacket;)V"}, at={@At(value="HEAD")})
    public void onScreenHandlerSlotUpdate(class_2653 packet, CallbackInfo ci) {
        if (packet.method_11452() != 0 || !ThreadUtils.isMainThread()) {
            return;
        }
        class_1799 oldStack = ItemUtil.getPlayerSlotItems(packet.method_11450());
        class_1799 newStack = packet.method_11449();
        if (oldStack == null) {
            return;
        }
        int oldDmg = oldStack.method_7919();
        int newDmg = newStack.method_7919();
        if (ItemUtil.areEqualIgnoringDmg(oldStack, newStack) && oldDmg != newDmg && DamageListener.isTracked(newStack)) {
            if (oldDmg < newDmg) {
                DamageListener.onDamage(newStack);
            } else {
                DamageListener.onRepair(newStack);
            }
        }
    }

    @Inject(method={"onWorldTimeUpdate(Lnet/minecraft/network/packet/s2c/play/WorldTimeUpdateS2CPacket;)V"}, at={@At(value="RETURN")})
    public void onWorldTimeUpdate(class_2761 packet, CallbackInfo ci) {
        class_310 mc = this.getClient();
        WorldTimeListener.onTimeUpdate((int)(Math.abs(packet.method_11873()) % 24000L), (class_1937)mc.field_1687, (class_1657)mc.field_1724, mc.field_1755 instanceof class_434);
    }
}

