/*
 * Decompiled with CFR 0.152.
 */
package eu.gflash.notifmod.util;

import com.mojang.authlib.GameProfile;
import eu.gflash.notifmod.config.ModConfig;
import eu.gflash.notifmod.util.TextUtil;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_746;
import net.minecraft.class_7471;
import net.minecraft.class_7591;

public class Message {
    private static final class_2561 CHAT_NAME;
    public static final class_2561 CHAT_PRE_WARN;
    public static final class_2561 CHAT_PRE_INFO;

    public static void auto(Type type, Supplier<class_2561> msg) {
        Message.auto(type, msg, msg);
    }

    public static void auto(Type type, Supplier<class_2561> longMsg, Supplier<class_2561> shortMsg) {
        switch (type) {
            case CHAT: {
                Message.chat(longMsg.get());
                break;
            }
            case ACTIONBAR: {
                Message.actionBar(longMsg.get());
                break;
            }
            case TITLE: {
                Message.title(shortMsg.get());
                break;
            }
            case SUBTITLE: {
                Message.subTitle(longMsg.get());
            }
        }
    }

    public static void autoWithPre(Type type, Supplier<class_2561> msg) {
        Message.autoWithPre(type, msg, msg);
    }

    public static void autoWithPre(Type type, Supplier<class_2561> longMsg, Supplier<class_2561> shortMsg) {
        Message.auto(type, () -> TextUtil.buildText(CHAT_PRE_INFO, (class_2561)longMsg.get()), shortMsg);
    }

    public static void chat(class_2561 msg) {
        Message.getPlayer().method_7353(TextUtil.buildText(CHAT_NAME, msg), false);
    }

    public static void actionBar(class_2561 msg) {
        Message.getPlayer().method_7353(msg, true);
    }

    public static void title(class_2561 msg) {
        Message.getHud().method_1742();
        Message.getHud().method_34004(msg);
        Message.getHud().method_34002(TextUtil.EMPTY);
    }

    public static void subTitle(class_2561 msg) {
        Message.title(TextUtil.EMPTY);
        Message.getHud().method_34002(msg);
    }

    private static class_2561 getPrefix(String langKey, class_124 color) {
        return TextUtil.buildText(TextUtil.getWithFormat((class_2561)class_2561.method_43471((String)langKey), color), TextUtil.getWithFormat(": ", class_124.field_1080));
    }

    private static class_329 getHud() {
        return class_310.method_1551().field_1705;
    }

    private static class_746 getPlayer() {
        return class_310.method_1551().field_1724;
    }

    static {
        CHAT_PRE_WARN = Message.getPrefix("msg.notifmod.pre.warn", class_124.field_1061);
        CHAT_PRE_INFO = Message.getPrefix("msg.notifmod.pre.info", class_124.field_1060);
        CHAT_NAME = TextUtil.buildText(TextUtil.getWithFormat("[", class_124.field_1080), TextUtil.getWithFormat((class_2561)class_2561.method_43471((String)"msg.notifmod.chat.name"), class_124.field_1076), TextUtil.getWithFormat("] ", class_124.field_1080));
    }

    public static enum Type {
        NONE,
        CHAT,
        ACTIONBAR,
        TITLE,
        SUBTITLE;


        public String toString() {
            return "text.autoconfig.notifmod.enum.message.type." + this.name().toLowerCase();
        }

        public void msg(Supplier<class_2561> msg) {
            Message.auto(this, msg);
        }

        public void msg(Supplier<class_2561> longMsg, Supplier<class_2561> shortMsg) {
            Message.auto(this, longMsg, shortMsg);
        }

        public void msgWithPre(Supplier<class_2561> msg) {
            Message.autoWithPre(this, msg);
        }

        public void msgWithPre(Supplier<class_2561> longMsg, Supplier<class_2561> shortMsg) {
            Message.autoWithPre(this, longMsg, shortMsg);
        }
    }

    public static class Incoming {
        private static Incoming latest;
        private final GameProfile sender;
        private final class_2556.class_7602 params;
        private final class_7471 message;
        private final class_2561 msgTxt;
        public NotifType notifType = NotifType.NONE;

        private static Incoming setLatest(Incoming newMsg) {
            latest = newMsg;
            return latest;
        }

        public static Incoming mkNew(GameProfile sender, class_2556.class_7602 params, class_7471 message) {
            return Incoming.setLatest(new Incoming(sender, params, message));
        }

        public static Incoming mkNew(class_2556.class_7602 params, class_2561 message) {
            return Incoming.setLatest(new Incoming(params, message));
        }

        public static Incoming mkNew(class_2561 message) {
            return Incoming.setLatest(new Incoming(message));
        }

        private Incoming(GameProfile sender, class_2556.class_7602 params, class_7471 message, class_2561 msgTxt) {
            this.sender = sender;
            this.params = params;
            this.message = message;
            this.msgTxt = msgTxt;
        }

        private Incoming(GameProfile sender, class_2556.class_7602 params, class_7471 message) {
            this(sender, params, message, Incoming.msgToTxt(sender, message));
        }

        private Incoming(class_2556.class_7602 params, class_2561 message) {
            this(null, params, null, message);
        }

        private Incoming(class_2561 message) {
            this(null, message);
        }

        private static class_2561 msgToTxt(GameProfile sender, class_7471 message) {
            if (message == null) {
                return class_2561.method_43473();
            }
            if (sender == null) {
                return message.method_46291();
            }
            return Optional.ofNullable(message.comp_981()).map(fm -> fm.method_45087() ? message.method_46291() : fm.method_46256(message.method_44862())).orElseGet(class_2561::method_43473);
        }

        public static Incoming latest() {
            return latest;
        }

        public class_2561 getDecorated() {
            return this.params == null ? this.msgTxt : this.params.method_44837(this.msgTxt);
        }

        public Channel channel() {
            if (this.params == null) {
                return Channel.GAME_INFO;
            }
            return this.hasSender() ? Channel.CHAT : Channel.SYSTEM;
        }

        public boolean senderIs(class_1657 player) {
            return this.hasSender() && this.sender.getId().equals(player.method_5667());
        }

        public GameProfile getSender() {
            return this.sender;
        }

        public class_7471 getMessage() {
            return this.message;
        }

        public class_2556.class_7602 getParams() {
            return this.params;
        }

        public class_2561 getMsgTxt() {
            return this.msgTxt;
        }

        public String toString() {
            return this.msgTxt.getString();
        }

        public boolean isEmpty() {
            return this.toString().isEmpty();
        }

        public boolean hasSender() {
            return this.sender != null;
        }

        public static enum NotifType {
            NONE,
            DROPPED,
            MESSAGE,
            MENTION;

        }

        public static class Customization {
            private static Optional<ModConfig.Chat.Sub> getSettings() {
                ModConfig.Chat settings = ModConfig.getInstance().chat;
                return Optional.ofNullable(Incoming.latest()).map(latest -> switch (latest.notifType) {
                    case NotifType.MENTION -> settings.mention;
                    case NotifType.MESSAGE -> settings.message;
                    default -> null;
                });
            }

            public static class_7591 mapIndicator(class_7591 indicator) {
                Optional<Integer> color = Customization.getSettings().filter(s -> s.enabled).map(s -> s.highlighting.indicator).filter(s -> s.enabled).map(s -> s.color);
                if (color.isEmpty()) {
                    return indicator;
                }
                if (indicator == null) {
                    indicator = class_7591.method_44709();
                }
                return new class_7591(color.get().intValue(), indicator.comp_900(), indicator.comp_901(), indicator.comp_902());
            }

            public static class_2561 mapText(class_2561 message) {
                return Customization.getSettings().filter(s -> s.enabled).map(s -> s.highlighting.matchedTextStyle).filter(ModConfig.Chat.Sub.Highlighting.MatchedTextStyle::isEnabled).map(s -> s.fill(message)).orElse(message);
            }
        }
    }

    public static enum Channel {
        CHAT,
        SYSTEM,
        GAME_INFO;


        public String toString() {
            return super.toString().toLowerCase().replace('_', ' ');
        }
    }

    public static enum ChannelCombo {
        NONE,
        CHAT,
        SYSTEM,
        CHAT_SYSTEM,
        GAMEINFO,
        CHAT_GAMEINFO,
        SYSTEM_GAMEINFO,
        ALL;


        public String toString() {
            return "text.autoconfig.notifmod.enum.message.channelCombo." + this.name().toLowerCase();
        }
    }
}

