/*
 * Decompiled with CFR 0.152.
 */
package eu.gflash.notifmod.util;

import org.apache.commons.lang3.tuple.Triple;

public class NumUtil {
    public static double mapValue(int value, int min, int max) {
        return ((double)value - (double)min) / (double)(max - min);
    }

    public static long mapValue(double value, int min, int max) {
        return Math.round((double)(max - min) * value) + (long)min;
    }

    public static Triple<Integer, Integer, Integer> secToHMS(int seconds) {
        int s = seconds % 60;
        int hm = seconds / 60;
        int m = hm % 60;
        int h = hm / 60;
        return Triple.of((Object)h, (Object)m, (Object)s);
    }

    public static String secToHMSString(int seconds) {
        Triple<Integer, Integer, Integer> hms = NumUtil.secToHMS(seconds);
        return NumUtil.padHMSNum((Integer)hms.getLeft()) + ":" + NumUtil.padHMSNum((Integer)hms.getMiddle()) + ":" + NumUtil.padHMSNum((Integer)hms.getRight());
    }

    private static String padHMSNum(int num) {
        return String.format("%02d", num);
    }

    public static int HMSToSec(int hours, int minutes, int seconds) {
        return hours * 3600 + minutes * 60 + seconds;
    }
}

