/*
 * Decompiled with CFR 0.152.
 */
package eu.gflash.notifmod.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class RegExUtil {

    public static class MatchSegmentation {
        private final Matcher matcher;
        private final String whole;
        private final List<MatchSegment> segments = new ArrayList<MatchSegment>();

        public MatchSegmentation(String pattern, String whole) {
            this(Pattern.compile(pattern), whole);
        }

        public MatchSegmentation(Pattern pattern, String whole) {
            this.matcher = pattern.matcher(whole);
            this.whole = whole;
        }

        public List<MatchSegment> get() {
            if (this.whole == null || !this.segments.isEmpty()) {
                return this.segments;
            }
            int prevPos = 0;
            while (this.matcher.find()) {
                this.addMatchSeg(prevPos, this.matcher.start(), false);
                this.addMatchSeg(this.matcher.start(), this.matcher.end(), true);
                prevPos = this.matcher.end();
            }
            this.addMatchSeg(prevPos, -1, false);
            return this.segments;
        }

        private void addMatchSeg(int start, int end, boolean matched) {
            String seg = this.whole.substring(start, end < 0 ? this.whole.length() : end);
            if (!seg.isEmpty()) {
                this.segments.add(new MatchSegment(seg, matched));
            }
        }

        public record MatchSegment(String str, boolean matched) {
            @Override
            public String toString() {
                return (this.matched ? "" : "NON-") + "MATCHED: \"" + this.str + "\"";
            }
        }
    }
}

